/*
 * TraceWindowManager.cpp
 *
 *  Created on: 29.06.2010
 *      Author: stefan.detter
 */

#include "TraceWindowManager.h"

#include <QDockWidget>
#include <QTableView>
#include <QPushButton>
#include <QHeaderView>
#include <QrfeTrace>
#include <QrfeTraceModel>

TraceWindowManager::TraceWindowManager(QDockWidget* traceDockWidget, QTableView* traceTableView, QPushButton* clearButton, QPushButton* exportButton, QObject* parent)
	: QObject(parent)
	, m_traceDockWidget(traceDockWidget)
	, m_traceTableView(traceTableView)
	, m_clearButton(clearButton)
	, m_exportButton(exportButton)
{
	m_traceDockWidget->setVisible(false);

	m_traceModel = new QrfeTraceModel(this);
	m_traceModel->setView(m_traceTableView);

	connect(m_clearButton, 					SIGNAL(clicked()),
            this,                             SLOT(clear()));
	connect(m_exportButton, 				SIGNAL(clicked()),
			m_traceModel, 				  	  SLOT(exportTrace()));

	m_traceTableView->resize(0, 65);
    m_traceTableView->horizontalHeader()->setSectionResizeMode(4, QHeaderView::Stretch);
}

TraceWindowManager::~TraceWindowManager()
{
	delete m_traceModel;
}

void TraceWindowManager::showTraceWindow(bool show)
{
	m_traceModel->setEnabled(show);

	if(!m_traceDockWidget->isVisible() && show){
		m_traceModel->clear();
	}
    m_traceTableView->horizontalHeader()->setSectionResizeMode(4, QHeaderView::Stretch);
    m_traceDockWidget->setVisible(show);
}

void TraceWindowManager::clear()
{
    m_traceModel->clear();
    m_traceTableView->horizontalHeader()->setSectionResizeMode(4, QHeaderView::Stretch);
}


